#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils import *

class View:

    def __init__(self):
        self.cms = 'contents'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):
        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        if scfg.get("PAGEMAKE") is not None:
            if scfg.get("PAGEMAKE") == 'HTML':
                pages = GetHtmlMenuPages() 

        return render.contents(     
                                    cms = self.cms,                        
                                    scfg = scfg, 
                                    pages = pages,
                                    mode = 'view',
                                    id = None,
                                    html_file = None,
        )


class Edit:

    def __init__(self):
        self.cms = 'contents'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self, id="index" ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            bs = BeautifulSoup(file.read(),"html5lib",fromEncoding="utf8")
            file.close()
        except:
            pass

        if fields is None:
            fields = {}
       
        html_fields = {}

        n = 1
        for h in bs.find_all(re.compile("h['1','2','3','4','5']")):
            paneo_type = h.get('data-paneo-type')
            paneo_name = h.get('data-paneo-name')
            title = h.get('title')
            if paneo_name is not None and paneo_type is not None:
                if paneo_type == "text":
                    k = 'h_%s_%s'%(id,paneo_name)
                    f = fields.get(k)
                    if f :
                        string = f.get('string')
                    else:
                        string = "".join([unicode(t) for t in h.contents])

                    if title is None:
                        title = u"タイトル%s" % n
                    html_fields[k] = { 'idx':n , 'tag':'h' , 'paneo_type': paneo_type,'paneo-name':paneo_name,'title':title, 'string':string } 
                    n = n + 1

        n = 101
        for p in bs.find_all('p'):
            paneo_type = p.get('data-paneo-type')
            paneo_name = p.get('data-paneo-name')
            title = p.get('title')
            if paneo_name is not None and paneo_type is not None:
                if paneo_type == "text" or paneo_type == 'textarea':
                    k = 'p_%s_%s'%(id,paneo_name)
                    f = fields.get(k)
                    if f :
                        string = f.get('string')
                    else:
                        string = "".join([unicode(t) for t in p.contents])

                    if title is None:
                        title = u"テキスト%s" % n - 100 
                    html_fields[k] = { 'idx':n , 'tag':'p' , 'paneo_type': paneo_type,'paneo-name':paneo_name,'title':title, 'string':string } 
                    n = n + 1

        n = 201
        for a in bs.find_all('a'):
            paneo_type = a.get('data-paneo-type')
            paneo_name = a.get('data-paneo-name')
            title = a.get('title')
            if paneo_name is not None and paneo_type is not None:
                if paneo_type == "text-link" :
                    k = 'a_%s_%s'%(id,paneo_name)
                    f = fields.get(k)
                    if f :
                        string = f.get('string')
                        href = f.get('href')
                    else:
                        string = "".join([unicode(t) for t in a.contents])
                        href = a.get('href')

                    if title is None:
                        title = u"テキストリンク%s" % n
                    html_fields[k] = { 'idx':n , 'tag':'a' , 'paneo_type': paneo_type,'paneo-name':paneo_name,'title':title, 'string':string, 'href':href } 
                    n = n + 1

        return render.contents(     
                                    cms = self.cms,                        
                                    mode = 'edit',
                                    id = id,
                                    scfg = scfg, 
                                    pages = pages,
                                    bs = bs,
                                    html_fields = html_fields,
        )

    def POST( self, id="index"):

        i = web.input()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')

        #FIELDSの更新
        fields = dic.get('fields')
        for k,v in i.items():
            if k[0:2] == 'a_' and k[-4] != '_href':
                fields[k] = {'string':v,'href':i.get(k+'_href')}
            else:
                fields[k] = {'string':v}
        dic['fields'] = fields
        dic.close()

        return self.GET( id )


